/*
 * Decompiled with CFR 0.152.
 */
package examples.sensor;

class Vector {
    private double x;
    private double y;

    public Vector(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    public Vector(Vector vector) {
        this(vector.getX(), vector.getY());
    }

    public static Vector add(Vector vector, Vector vector2) {
        return new Vector(vector.getX() + vector2.getX(), vector.getY() + vector2.getY());
    }

    public Vector inv() {
        return new Vector(this.getX() * -1.0, this.getY() * -1.0);
    }

    public static Vector mul(Vector vector, double d2) {
        return new Vector(vector.getX() * d2, vector.getY() * d2);
    }

    public static double dot(Vector vector, Vector vector2) {
        return vector.getX() * vector2.getX() + vector.getY() * vector2.getY();
    }

    public Vector norm() {
        double d2 = Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY());
        return new Vector(this.getX() / d2, this.getY() / d2);
    }

    public static Vector sub(Vector vector, Vector vector2) {
        return new Vector(vector.getX() - vector2.getX(), vector.getY() - vector2.getY());
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public void mul(double d2) {
        this.mulX(d2);
        this.mulY(d2);
    }

    public void mulX(double d2) {
        this.x *= d2;
    }

    public void mulY(double d2) {
        this.y *= d2;
    }

    public void add(double d2) {
        this.x += d2;
        this.y += d2;
    }

    public void add(Vector vector) {
        this.x += vector.x;
        this.y += vector.y;
    }

    public void setX(double d2) {
        this.x = d2;
    }

    public void setY(double d2) {
        this.y = d2;
    }

    public String toString() {
        return "[" + this.getX() + ";" + this.getY() + "]";
    }
}

