/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network.bluetooth;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import multipacman.PacmanMIDlet;
import multipacman.util.Observable;

public class BluetoothDiscovery
extends Observable
implements DiscoveryListener,
Runnable {
    private Vector deviceList = new Vector();
    private Vector deviceListInquiry = new Vector();
    private Vector recordList = new Vector();
    private Vector transIDs = new Vector();
    private LocalDevice local;
    private DiscoveryAgent agent;
    private String[] nameList = null;
    private PacmanMIDlet midlet;
    private int transID;
    private boolean isRunning = false;
    private Thread t;

    public BluetoothDiscovery(PacmanMIDlet pacmanMIDlet) {
        this.midlet = pacmanMIDlet;
        this.t = new Thread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchServices(Vector list) {
        UUID[] searchList = new UUID[]{new UUID("2D26618601FB47C28D9F10B8EC891363", false)};
        Enumeration enumDevices = list.elements();
        if (list.size() > 0) {
            Vector vector = this.transIDs;
            synchronized (vector) {
                while (enumDevices.hasMoreElements() && this.isRunning) {
                    RemoteDevice device = (RemoteDevice)enumDevices.nextElement();
                    if (this.transIDs.size() == Integer.parseInt(LocalDevice.getProperty((String)"bluetooth.sd.trans.max"))) {
                        try {
                            this.transIDs.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    try {
                        this.transIDs.addElement(new Integer(this.agent.searchServices(null, searchList, device, (DiscoveryListener)this)));
                    }
                    catch (BluetoothStateException e1) {}
                }
                try {
                    this.transIDs.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        this.deviceList.removeAllElements();
        this.deviceListInquiry.removeAllElements();
        this.recordList.removeAllElements();
        try {
            int i;
            this.local = LocalDevice.getLocalDevice();
            this.agent = this.local.getDiscoveryAgent();
            RemoteDevice[] preknown = this.agent.retrieveDevices(1);
            if (preknown != null) {
                for (i = 0; i < preknown.length; ++i) {
                    this.deviceList.addElement(preknown[i]);
                }
            }
            if ((preknown = this.agent.retrieveDevices(0)) != null) {
                for (i = 0; i < preknown.length; ++i) {
                    if (this.deviceList.contains(preknown[i])) continue;
                    this.deviceList.addElement(preknown[i]);
                }
            }
            if (!this.deviceList.isEmpty()) {
                this.searchServices(this.deviceList);
                BluetoothDiscovery bluetoothDiscovery = this;
                synchronized (bluetoothDiscovery) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        Vector vector = this.deviceList;
        synchronized (vector) {
            if (!this.deviceList.contains(btDevice)) {
                this.deviceListInquiry.addElement(btDevice);
            }
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        this.recordList.addElement(servRecord[0]);
        this.setChanged();
        try {
            this.notifyObservers(servRecord[0].getHostDevice().getFriendlyName(true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        Vector vector = this.transIDs;
        synchronized (vector) {
            this.transIDs.removeElement(new Integer(transID));
            this.transIDs.notify();
            if (this.transIDs.isEmpty()) {
                BluetoothDiscovery bluetoothDiscovery = this;
                synchronized (bluetoothDiscovery) {
                    this.notify();
                }
            }
        }
    }

    public void inquiryCompleted(int discType) {
        if (discType == 0) {
            this.searchServices(this.deviceListInquiry);
        }
    }

    public ServiceRecord getServiceRecord(int i) {
        return (ServiceRecord)this.recordList.elementAt(i);
    }

    public void finish() {
        this.isRunning = false;
        this.agent.cancelInquiry((DiscoveryListener)this);
        Enumeration enumeration = this.transIDs.elements();
        while (enumeration.hasMoreElements()) {
            this.agent.cancelServiceSearch(((Integer)enumeration.nextElement()).intValue());
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

