/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network.bluetooth;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import multipacman.network.CommandPacket;
import multipacman.network.ConnectionErrorHandler;
import multipacman.network.ConnectionListener;
import multipacman.network.NetworkListener;
import multipacman.network.NetworkManager;
import multipacman.network.Packet;
import multipacman.network.bluetooth.ReceiveThread;
import multipacman.network.bluetooth.SendThread;

public class BluetoothClient
implements NetworkListener,
NetworkManager,
ConnectionErrorHandler {
    private L2CAPConnection connection;
    private ServiceRecord record;
    private SendThread sendThread;
    private ReceiveThread receiveThread;
    private NetworkListener listener = null;
    private NetworkListener tempListener = null;
    private Thread t;
    private int networkID = 0;
    private Vector connectionListeners = new Vector();

    public BluetoothClient(ServiceRecord record) {
        this.record = record;
        this.tempListener = this.listener = new NetworkListener(){
            private NetworkListener nextListener = null;

            public synchronized void receive(Packet packet) {
                BluetoothClient.this.networkID = Integer.parseInt(((CommandPacket)packet).getCommand());
                BluetoothClient.this.listener = this.nextListener;
            }

            public synchronized void setNextListener(NetworkListener networkListener) {
                if (BluetoothClient.this.networkID == 0) {
                    this.nextListener = networkListener;
                } else {
                    BluetoothClient.this.listener = networkListener;
                }
            }
        };
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        try {
            this.connection = (L2CAPConnection)Connector.open((String)this.record.getConnectionURL(0, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendThread = new SendThread(this.connection);
        this.receiveThread = new ReceiveThread(this.connection, this);
        this.sendThread.setConnectionErrorHandler(this);
        this.sendThread.start();
        this.receiveThread.setConnectionErrorHandler(this);
        this.receiveThread.start();
    }

    public void send(int destID, Packet packet) {
        packet.setSourceID(this.networkID);
        packet.setDestID(destID);
        packet.setReferences(1);
        this.sendThread.send(packet);
    }

    public void sendAll(Packet packet) {
        packet.setSourceID(this.networkID);
        packet.setDestID(15);
        packet.setReferences(1);
        this.sendThread.send(packet);
    }

    public void receive(Packet packet) {
        packet.setReferences(1);
        this.listener.receive(packet);
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setNextListener(NetworkListener listener) {
        this.tempListener.setNextListener(listener);
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public void connectionError(Object o) {
        Enumeration enumeration = this.connectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ConnectionListener)enumeration.nextElement()).closedConnection(0);
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.addElement(connectionListener);
    }

    public void removeAllConnectionListener() {
        this.connectionListeners.removeAllElements();
    }
}

