/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import java.util.Stack;
import multipacman.game.Controller;
import multipacman.game.Field;
import multipacman.network.CommandPacket;
import multipacman.network.FieldPacket;
import multipacman.network.Packet;
import multipacman.network.PositionPacket;
import multipacman.network.StatusPacket;

public class PacketFactory {
    private static PacketFactory reference = null;
    public static final int POSITION_PACKET = 0;
    public static final int COMMAND_PACKET = 1;
    public static final int STATUS_PACKET = 2;
    public static final int FIELD_PACKET = 3;
    private static Stack[] packetLists = new Stack[4];
    private Controller[] controllerList;
    private Field field;

    public PacketFactory(Controller[] controllerList, Field field) {
        this();
        this.controllerList = controllerList;
        this.field = field;
    }

    public PacketFactory() {
        reference = this;
        for (int i = 0; i < packetLists.length; ++i) {
            PacketFactory.packetLists[i] = new Stack();
        }
    }

    public void setControllerList(Controller[] controllerList) {
        this.controllerList = controllerList;
    }

    public static PacketFactory getPacketFactory() {
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getPacket(int packetType) {
        Stack stack = packetLists[packetType];
        synchronized (stack) {
            if (packetLists[packetType].empty()) {
                switch (packetType) {
                    case 0: {
                        return new PositionPacket();
                    }
                    case 1: {
                        return new CommandPacket();
                    }
                    case 2: {
                        return new StatusPacket();
                    }
                    case 3: {
                        return new FieldPacket();
                    }
                }
                return null;
            }
            Packet packet = (Packet)packetLists[packetType].pop();
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getPacket(byte[] data, int length) {
        switch (data[0] & 0xF) {
            case 0: {
                Stack stack = packetLists[0];
                synchronized (stack) {
                    if (packetLists[0].empty()) {
                        return new PositionPacket(data, length, this.controllerList[data[2]]);
                    }
                    PositionPacket packet = (PositionPacket)packetLists[0].pop();
                    packet.parseByteArray(data, length);
                    packet.setController(this.controllerList[packet.getActorID()]);
                    return packet;
                }
            }
            case 1: {
                Stack stack = packetLists[1];
                synchronized (stack) {
                    if (packetLists[1].empty()) {
                        return new CommandPacket(data, length);
                    }
                    CommandPacket packet = (CommandPacket)packetLists[1].pop();
                    packet.parseByteArray(data, length);
                    return packet;
                }
            }
            case 2: {
                Stack stack = packetLists[2];
                synchronized (stack) {
                    if (packetLists[2].empty()) {
                        return new StatusPacket(data, length, this.controllerList[data[2]]);
                    }
                    StatusPacket packet = (StatusPacket)packetLists[2].pop();
                    packet.parseByteArray(data, length);
                    packet.setController(this.controllerList[packet.getActorID()]);
                    return packet;
                }
            }
            case 3: {
                Stack stack = packetLists[3];
                synchronized (stack) {
                    if (packetLists[3].empty()) {
                        FieldPacket packet = new FieldPacket();
                        packet.parseByteArray(data, length);
                        packet.setField(this.field);
                        return packet;
                    }
                    FieldPacket packet = (FieldPacket)packetLists[3].pop();
                    packet.parseByteArray(data, length);
                    packet.setField(this.field);
                    return packet;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePacket(Packet packet) {
        Stack stack = packetLists[packet.getType()];
        synchronized (stack) {
            packetLists[packet.getType()].push(packet);
        }
    }

    public void setField(Field field) {
        this.field = field;
    }
}

