/*
 * Decompiled with CFR 0.152.
 */
package multipacman.network;

import multipacman.network.Packet;

public class CommandPacket
extends Packet {
    private String command;

    public CommandPacket(String command) {
        this.command = command;
    }

    public CommandPacket() {
    }

    public CommandPacket(byte[] data, int length) {
        this.parseByteArray(data, length);
    }

    public byte[] getByteArray() {
        byte[] array = new byte[this.command.length() + 2];
        byte[] byteCommand = this.command.getBytes();
        System.arraycopy(byteCommand, 0, array, 2, byteCommand.length);
        array[0] = 1;
        array[1] = (byte)(this.sourceID | this.destID << 4);
        return array;
    }

    public void parseByteArray(byte[] data, int length) {
        this.command = new String(data, 2, length - 2);
        this.sourceID = data[1] & 0xF;
        this.destID = (data[1] & 0xFF) >> 4;
    }

    public String getCommand() {
        return this.command;
    }

    public int getType() {
        return 1;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

