/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import multipacman.PacmanMIDlet;
import multipacman.game.Accelerometer;
import multipacman.game.Actor;
import multipacman.game.ActorGhost;
import multipacman.game.ActorPacman;
import multipacman.game.Controller;
import multipacman.game.ControllerGhost;
import multipacman.game.ControllerPacman;
import multipacman.game.Field;
import multipacman.game.Sound;

public class World
extends GameCanvas
implements Runnable {
    private Accelerometer Sensor;
    public static final int UP = 0;
    public static final int LEFT = 1;
    public static final int DOWN = 2;
    public static final int RIGHT = 3;
    public static final int NONE = 9;
    public static final int CLYDE = 0;
    public static final int BLINKY = 1;
    public static final int PINKY = 2;
    public static final int INKY = 3;
    public static final int PACMAN = 4;
    private static final int MILLIS_PER_TICK_DRAW = 75;
    private static final int MILLIS_PER_TICK_LOGIC = 75;
    private PacmanMIDlet midlet;
    private Field field;
    private LayerManager layerManager;
    private int myActor;
    private Actor[] actors = new Actor[5];
    private Controller[] controller = new Controller[5];
    private Controller inputHandler;
    private ControllerPacman pacman;
    public static Sound sound = new Sound();
    private final Graphics graphics;
    private long gameDuration;
    private long startTime;
    private volatile Thread animationThread = null;
    private Thread logicThread = null;
    private int live;
    private int level;
    private final int STARTDELAY;

    public World(PacmanMIDlet midlet, Accelerometer sensor) {
        super(true);
        int i;
        this.STARTDELAY = 3;
        this.midlet = midlet;
        this.Sensor = sensor;
        this.setFullScreenMode(true);
        this.graphics = this.getGraphics();
        this.layerManager = new LayerManager();
        this.field = new Field();
        this.actors[4] = new ActorPacman(this, new ControllerPacman(this.field, this));
        for (i = 0; i < 4; i = (byte)(i + 1)) {
            this.actors[i] = new ActorGhost(this, (byte)i, new ControllerGhost(this.field));
        }
        for (i = 0; i < 5; ++i) {
            this.controller[i] = this.actors[i].getController();
            this.layerManager.append((Layer)this.actors[i]);
        }
        this.pacman = (ControllerPacman)this.controller[4];
        this.init();
        this.layerManager.append((Layer)this.field.getTiledLayer());
    }

    public void setActor(int actor) {
        this.myActor = actor;
        this.controller[this.myActor].setAIMode(1);
        this.inputHandler = this.controller[actor];
    }

    public void keyPressed(int keyCode) {
        if (keyCode < 0) {
            this.stop();
            this.midlet.pacmanCanvasMenu();
        }
    }

    public void init() {
        this.level = 0;
        this.live = 3;
        this.level_init();
    }

    public void init_MP() {
        this.level = 0;
        this.live = 3;
        this.level_init();
    }

    public void loadMap(String filename) {
        this.layerManager.remove((Layer)this.field.getTiledLayer());
        this.field.loadMap(filename);
        this.layerManager.append((Layer)this.field.getTiledLayer());
    }

    private void level_init() {
        ++this.level;
        this.field.init();
        this.actors[4].setRefPixelPosition(94, 124);
        this.actors[1].setRefPixelPosition(96, 84);
        this.actors[3].setRefPixelPosition(85, 106);
        this.actors[2].setRefPixelPosition(95, 106);
        this.actors[0].setRefPixelPosition(105, 106);
        this.pacman.reset();
    }

    public synchronized void start() {
        Runnable gameLogic = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (World.this.logicThread == Thread.currentThread()) {
                    long startTimeLogic = System.currentTimeMillis();
                    World.this.updateGameState();
                    World.this.handleInput();
                    long timeTakenLogic = System.currentTimeMillis() - startTimeLogic;
                    if (timeTakenLogic >= 75L) continue;
                    1 var5_3 = this;
                    synchronized (var5_3) {
                        try {
                            this.wait(75L - timeTakenLogic);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.animationThread = new Thread(this);
        this.logicThread = new Thread(gameLogic);
        this.animationThread.start();
        sound.playMusic();
        sound.playOpening();
        this.startTime = System.currentTimeMillis() - this.gameDuration;
    }

    public synchronized void stop() {
        this.gameDuration = System.currentTimeMillis() - this.startTime;
        this.animationThread = null;
        this.logicThread = null;
        sound.stopMusic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay(int seconds) {
        int counter = 0;
        while (counter < seconds) {
            ++counter;
            this.draw();
            this.draw_level();
            this.flushGraphics();
            World world = this;
            synchronized (world) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.delay(3);
        this.logicThread.start();
        while (this.animationThread == Thread.currentThread()) {
            long timeTaken;
            long startTime = System.currentTimeMillis();
            if (this.isShown()) {
                this.draw();
                this.flushGraphics();
            }
            if ((timeTaken = System.currentTimeMillis() - startTime) >= 75L) continue;
            World world = this;
            synchronized (world) {
                try {
                    this.wait(75L - timeTaken);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleInput() {
        int direction;
        int n = this.Sensor.m_accY < -2 ? 0 : (this.Sensor.m_accX > 2 ? 1 : (this.Sensor.m_accY > 2 ? 2 : (direction = this.Sensor.m_accX < -2 ? 3 : 9)));
        if (this.inputHandler.getNextDirection() != direction && direction != 9) {
            this.inputHandler.setNextDirection(direction);
        }
        for (int i = 0; i < 5; ++i) {
            this.controller[i].makeMove();
        }
    }

    private void updateGameState() {
        if (this.live == 0) {
            this.midlet.pacmanCanvasGameOver(this.pacman.getScore());
        }
        if (this.field.getPills() == 0) {
            this.level_init();
        }
        this.field.tick();
    }

    public Field getField() {
        return this.field;
    }

    int getPacmanX() {
        return this.actors[4].getRefPixelX();
    }

    int getPacmanY() {
        return this.actors[4].getRefPixelY();
    }

    boolean isPacmanDead() {
        return !this.actors[4].isAlive();
    }

    void setKill() {
        --this.live;
    }

    void vibrate(int millis) {
        this.midlet.vibrate(millis);
    }

    private void draw() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.graphics.setColor(0);
        this.graphics.fillRect(0, 0, width, height);
        int dx = this.origin(this.actors[this.myActor].getX() + this.actors[this.myActor].getWidth() / 2, this.field.getWidth(), width);
        int dy = this.origin(this.actors[this.myActor].getY() + this.actors[this.myActor].getHeight() / 2, this.field.getHeight(), height - 13);
        this.graphics.setClip(dx, dy, this.field.getWidth(), this.field.getHeight());
        this.graphics.translate(dx, dy);
        this.layerManager.paint(this.graphics, 0, 0);
        this.graphics.translate(-dx, -dy);
        this.graphics.setClip(0, 0, width, height);
        this.graphics.setColor(0);
        this.graphics.fillRect(0, height - 13, width, 13);
        this.graphics.setColor(0xFFFFFF);
        this.graphics.setFont(Font.getDefaultFont());
        this.graphics.drawString(Integer.toString(this.pacman.getScore()), width - 1, height, 40);
        this.graphics.setColor(0xFFFF00);
        int yPos = this.getHeight() - 10;
        int xPos = 0;
        for (int livePrint = this.live; livePrint > 0; --livePrint) {
            this.graphics.fillArc(xPos, yPos, 7, 7, 45, 270);
            xPos += 10;
        }
    }

    private void draw_level() {
        String slevel = "Level " + Integer.toString(this.level);
        this.graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        this.graphics.setColor(0);
        this.graphics.drawString(slevel, centerX, centerY - 1, 33);
        this.graphics.drawString(slevel, centerX, centerY + 1, 33);
        this.graphics.drawString(slevel, centerX - 1, centerY, 33);
        this.graphics.drawString(slevel, centerX + 1, centerY, 33);
        this.graphics.setColor(0xFFFF00);
        this.graphics.drawString(slevel, centerX, centerY, 33);
    }

    private int origin(int focus, int fieldLength, int screenLength) {
        int origin = screenLength >= fieldLength ? (screenLength - fieldLength) / 2 : (focus <= screenLength / 2 ? 0 : (focus >= fieldLength - screenLength / 2 ? screenLength - fieldLength : screenLength / 2 - focus));
        return origin;
    }

    public Controller[] getController() {
        return this.controller;
    }

    public boolean isInBlinkingMode() {
        return this.pacman.isInBlinkingMode();
    }

    public boolean isInMagicMode() {
        return this.pacman.isInMagicMode();
    }

    public int getScore() {
        return this.pacman.getScore();
    }

    public void checkField() {
        int mapY;
        int mapX = this.actors[4].getRefPixelX() / 10;
        if (this.field.eatPill(mapX, mapY = this.actors[4].getRefPixelY() / 10) && this.pacman.getAIMode() != 2) {
            this.pacman.eatPill();
        }
        if (this.field.eatMagicPill(mapX, mapY) && this.pacman.getAIMode() != 2) {
            this.pacman.eatMagicPill();
        }
    }

    public void detectCollisions() {
        for (int i = 0; i < 4; ++i) {
            if (!this.actors[4].collidesWith(this.actors[i], false) || !this.actors[i].isAlive()) continue;
            this.pacman.onCollision(this.controller[i]);
            this.controller[i].onCollision(this.pacman);
        }
    }
}

