/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Sound {
    private final String TYPE_WAVE;
    private final String TYPE_MIDI;
    private Player musicPlayer = this.openMidi("/res/amaril.mid");
    private Player eatGhostPlayer = this.openWave("/res/eating_ghost.wav");
    private Player eatShortPlayer = this.openWave("/res/eating_short.wav");
    private Player eatShortPlayer2 = this.openWave("/res/eating_short.wav");
    private Player diePlayer = this.openWave("/res/pacman_dies.wav");
    private Player sirenPlayer = this.openWave("/res/siren.wav");
    private Player openingPlayer = this.openWave("/res/opening.wav");
    private Player intermisPlayer = this.openWave("/res/intermission.wav");
    private final String music;
    private final String eatingG;
    private final String eatingS;
    private final String die;
    private final String siren;
    private final String opening;
    private final String interm;
    public static boolean musicEnabled = true;
    public static boolean fxEnabled = true;

    public Sound() {
        this.TYPE_WAVE = "audio/x-wav";
        this.TYPE_MIDI = "audio/midi";
        this.music = "/res/amaril.mid";
        this.eatingG = "/res/eating_ghost.wav";
        this.eatingS = "/res/eating_short.wav";
        this.die = "/res/pacman_dies.wav";
        this.siren = "/res/siren.wav";
        this.opening = "/res/opening.wav";
        this.interm = "/res/intermission.wav";
    }

    public void playMusic() {
        if (!musicEnabled) {
            return;
        }
        try {
            this.musicPlayer.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stopMusic() {
        try {
            this.musicPlayer.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playEatGhost() {
        if (!fxEnabled) {
            return;
        }
        try {
            this.eatGhostPlayer.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playEatShort() {
        if (!fxEnabled) {
            return;
        }
        try {
            if (this.eatShortPlayer.getState() == 400) {
                this.eatShortPlayer2.start();
            } else {
                this.eatShortPlayer.start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playDie() {
        if (!fxEnabled) {
            return;
        }
        try {
            this.diePlayer.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playSiren() {
        if (!fxEnabled) {
            return;
        }
        try {
            if (this.sirenPlayer.getState() != 400) {
                this.sirenPlayer.start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stopSiren() {
        try {
            this.sirenPlayer.stop();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void playOpening() {
        if (!fxEnabled) {
            return;
        }
        try {
            this.openingPlayer.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void playIntermission() {
        if (!fxEnabled) {
            return;
        }
        try {
            this.intermisPlayer.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private Player openMidi(String filename) {
        return this.openFile(filename, "audio/midi");
    }

    private Player openWave(String filename) {
        return this.openFile(filename, "audio/x-wav");
    }

    private Player openFile(String file, String type) {
        Class<?> c = this.getClass();
        InputStream is = c.getResourceAsStream(file);
        Player p = null;
        try {
            p = Manager.createPlayer((InputStream)is, (String)type);
            p.realize();
            p.prefetch();
        }
        catch (MediaException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return p;
    }
}

