/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import multipacman.PacmanMIDlet;
import multipacman.game.Actor;
import multipacman.game.ActorPacman;
import multipacman.game.Controller;
import multipacman.game.Field;
import multipacman.game.World;

public class ControllerPacman
extends Controller {
    private int nextDirection = 1;
    private int[] inputPosition = new int[2];
    private boolean jumpToPosition = false;
    private ActorPacman pacman;
    private World world;
    private long magicModeEnd;
    private boolean magicMode = false;
    private boolean blinkingMode = false;
    private int score;
    private static final int EATEN_BY_GHOST = 0;
    private static final int EAT_GHOST = 1;
    private static final int EAT_PILL = 2;
    private static final int RESET = 3;
    private static final int MILLIS_MAGICMODE = 10000;
    private static final int MILLIS_BLINKING = 3000;

    ControllerPacman(Field field, World world) {
        super(field);
        this.world = world;
    }

    public void setActor(Actor actor) {
        if (actor instanceof ActorPacman) {
            this.setPacman((ActorPacman)actor);
        }
    }

    public void setPacman(ActorPacman actor) {
        this.pacman = actor;
        this.inputPosition[0] = actor.getX();
        this.inputPosition[1] = actor.getY();
    }

    public void setNextDirection(int direction) {
        this.nextDirection = direction;
        this.setChanged();
        this.notifyObservers();
    }

    public int getNextDirection() {
        return this.nextDirection;
    }

    public int getDirection() {
        return this.currentDirection;
    }

    public void setPosition(int[] pos) {
        this.inputPosition = pos;
        this.jumpToPosition = true;
    }

    public int[] getPosition() {
        return this.pacman.getPosition();
    }

    public byte getId() {
        return 4;
    }

    public boolean isAlive() {
        return this.pacman.isAlive();
    }

    public void setAlive(boolean alive) {
        if (!alive && this.isAlive()) {
            this.world.setKill();
            World.sound.playDie();
            this.world.vibrate(500);
            this.pacman.setAlive(alive);
            this.setChanged();
            this.notifyObservers(new Integer(0));
        } else if (alive && !this.isAlive()) {
            this.pacman.reset();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void reset() {
        this.score = 0;
        this.setMagicMode(false);
        this.setBlinkingMode(false);
        this.magicModeEnd = System.currentTimeMillis() - 1L;
        this.pacman.reset();
    }

    public void makeMove() {
        if (this.pacman.isAlive()) {
            switch (this.mode) {
                case 0: {
                    long current = System.currentTimeMillis();
                    if (this.magicMode) {
                        if (this.magicModeEnd > current) {
                            if (!this.blinkingMode && this.magicModeEnd < current + 3000L) {
                                this.blinkingMode = true;
                                this.setChanged();
                                this.notifyObservers(new Integer(2));
                            }
                        } else {
                            this.setMagicMode(false);
                            this.setBlinkingMode(false);
                            this.setChanged();
                            this.notifyObservers(new Integer(2));
                        }
                    }
                    this.makeAIMove();
                    this.world.checkField();
                    this.world.detectCollisions();
                    break;
                }
                case 1: {
                    long current = System.currentTimeMillis();
                    if (this.magicMode) {
                        if (this.magicModeEnd > current) {
                            if (!this.blinkingMode && this.magicModeEnd < current + 3000L) {
                                this.blinkingMode = true;
                                this.setChanged();
                                this.notifyObservers(new Integer(2));
                            }
                        } else {
                            this.setMagicMode(false);
                            this.setBlinkingMode(false);
                            this.setChanged();
                            this.notifyObservers(new Integer(2));
                        }
                    }
                    this.tryDirection(this.nextDirection);
                    if (this.jumpToPosition) {
                        this.pacman.setPosition(this.inputPosition);
                        this.jumpToPosition = false;
                    } else {
                        this.pacman.setPosition(this.getNewPosition());
                    }
                    this.world.checkField();
                    this.world.detectCollisions();
                    break;
                }
                case 2: {
                    this.tryDirection(this.nextDirection);
                    if (this.jumpToPosition) {
                        this.pacman.setPosition(this.inputPosition);
                        this.jumpToPosition = false;
                        break;
                    }
                    this.pacman.setPosition(this.getNewPosition());
                }
            }
        }
        this.pacman.animate();
    }

    private void makeAIMove() {
        int[] turnDirections = new int[]{this.currentDirection, (this.currentDirection + 1) % 4, (this.currentDirection + 3) % 4};
        int random = PacmanMIDlet.random(3);
        while (!this.tryDirection(turnDirections[random])) {
            random = PacmanMIDlet.random(3);
        }
        if (this.nextDirection != this.currentDirection) {
            this.nextDirection = this.currentDirection;
            this.setChanged();
            this.notifyObservers();
        }
        this.pacman.setPosition(this.getNewPosition());
    }

    private int[] getNewPosition() {
        this.pacman.setMoving(false);
        int[] position = this.pacman.getPosition();
        int[] refPixel = new int[]{this.pacman.getRefPixelX(), this.pacman.getRefPixelY()};
        if (this.canWalk(this.currentDirection, position, refPixel)) {
            switch (this.currentDirection) {
                case 0: {
                    position[1] = position[1] - 2;
                    this.pacman.setMoving(true);
                    break;
                }
                case 1: {
                    position[0] = position[0] - 2;
                    this.pacman.setMoving(true);
                    break;
                }
                case 2: {
                    position[1] = position[1] + 2;
                    this.pacman.setMoving(true);
                    break;
                }
                case 3: {
                    position[0] = position[0] + 2;
                    this.pacman.setMoving(true);
                }
            }
        }
        return position;
    }

    private boolean tryDirection(int direction) {
        int[] position = this.pacman.getPosition();
        int[] refPixel = new int[]{this.pacman.getRefPixelX(), this.pacman.getRefPixelY()};
        if (this.canWalk(direction, position, refPixel)) {
            this.currentDirection = direction;
            this.pacman.setDirection(this.currentDirection);
            return true;
        }
        return false;
    }

    protected boolean canWalk(int direction, int[] position, int[] referencePixel) {
        int[] size = new int[]{this.pacman.getWidth() + 2, this.pacman.getHeight() + 2};
        switch (direction) {
            case 0: {
                if (position[1] <= 0 || this.field.containsPacmanImpassableArea(referencePixel[0], referencePixel[1] - 2, size[0], size[1])) break;
                return true;
            }
            case 1: {
                if (position[0] <= 0 || this.field.containsPacmanImpassableArea(referencePixel[0] - 2, referencePixel[1], size[0], size[1])) break;
                return true;
            }
            case 2: {
                if (position[1] >= this.field.getHeight() || this.field.containsPacmanImpassableArea(referencePixel[0], referencePixel[1] + 2, size[0], size[1])) break;
                return true;
            }
            case 3: {
                if (position[0] >= this.field.getWidth() || this.field.containsPacmanImpassableArea(referencePixel[0] + 2, referencePixel[1], size[0], size[1])) break;
                return true;
            }
        }
        return false;
    }

    public void onCollision(Controller collisionObject) {
        if (this.isInMagicMode()) {
            this.score += this.pacman.eaten++ * 10;
            World.sound.playEatGhost();
            this.setChanged();
            this.notifyObservers(new Integer(1));
        } else {
            this.setAlive(false);
        }
    }

    public void eatPill() {
        ++this.score;
        World.sound.playEatShort();
    }

    public void eatMagicPill() {
        this.score += 5;
        this.magicModeEnd = System.currentTimeMillis() + 10000L;
        this.setMagicMode(true);
        this.setChanged();
        this.notifyObservers(new Integer(2));
    }

    public boolean isInMagicMode() {
        return this.magicMode;
    }

    public boolean isInBlinkingMode() {
        return this.blinkingMode;
    }

    public void setMagicMode(boolean mode) {
        if (mode) {
            World.sound.playSiren();
        } else {
            World.sound.stopSiren();
        }
        this.magicMode = mode;
    }

    public void setBlinkingMode(boolean mode) {
        this.blinkingMode = mode;
    }

    public int getScore() {
        return this.score;
    }
}

