/*
 * Decompiled with CFR 0.152.
 */
package multipacman.game;

import multipacman.PacmanMIDlet;
import multipacman.game.Actor;
import multipacman.game.ControllerGhost;
import multipacman.game.Field;
import multipacman.game.World;

class ActorGhost
extends Actor {
    public int frameCount = 0;
    private Field field;
    private int[][][] animations = new int[][][]{new int[][]{{0}, {1}}, new int[][]{{2}, {3}}, new int[][]{{4}, {5}}, new int[][]{{6}, {7}}, new int[][]{{8}, {9}}, new int[][]{{10}, {11}}, new int[][]{{12}, {13}}};
    private int animationID;
    private int currentDirection = 1;
    private byte ghostID = 0;
    int i = 0;
    private boolean isMoving = false;

    ActorGhost(World canvas, byte number, ControllerGhost controller) {
        super(controller, PacmanMIDlet.createImage("/res/ghost.png"), 8, 8);
        this.defineCollisionRectangle(2, 2, 4, 4);
        this.defineReferencePixel(4, 4);
        this.canvas = canvas;
        this.ghostID = number;
        this.animationID = number;
        this.setFrame(this.animations[this.animationID][1][0]);
        this.field = canvas.getField();
        controller.setActor(this);
    }

    public int[] getPosition() {
        int[] pos = new int[]{this.getX(), this.getY()};
        return pos;
    }

    protected void handleJump() {
        if (this.getRefPixelX() <= 5) {
            this.setRefPixelPosition(this.field.getWidth() - 6, this.getRefPixelY());
        }
        if (this.getRefPixelX() >= this.field.getWidth() - 5) {
            this.setRefPixelPosition(6, this.getRefPixelY());
        }
    }

    public int getDirection() {
        return this.currentDirection;
    }

    protected void reset() {
        this.setRefPixelPosition(95, 106);
        this.setAlive(true);
    }

    private boolean blinkOn() {
        return ++this.i % 5 != 0;
    }

    public void animate() {
        this.animationID = this.ghostID;
        if (!this.isAlive()) {
            this.animationID = 5;
        } else if (this.canvas.isInMagicMode()) {
            this.animationID = this.canvas.isInBlinkingMode() && this.blinkOn() ? 6 : 4;
        }
        if (this.currentDirection == 0) {
            this.setFrame(this.animations[this.animationID][1][0]);
        } else {
            this.setFrame(this.animations[this.animationID][0][0]);
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    public void setDirection(int direction) {
        this.currentDirection = direction;
    }

    protected byte getId() {
        return this.ghostID;
    }
}

