/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import multipacman.PacmanMIDlet;
import multipacman.network.bluetooth.BluetoothDiscovery;
import multipacman.util.Observable;
import multipacman.util.Observer;

class ServerMenu
extends List
implements CommandListener,
Observer {
    private static final String title = "Select Server";
    private PacmanMIDlet midlet;
    private BluetoothDiscovery btThread;
    private static final Command CANCEL_CMD = new Command("Cancel", 3, 1);
    private static final Command RESTART_CMD = new Command("Restart", 4, 1);
    private static final Command OK_CMD = new Command("OK", 4, 1);

    public ServerMenu(PacmanMIDlet pacmanMIDlet, BluetoothDiscovery btThread) {
        super(title, 3);
        this.midlet = pacmanMIDlet;
        this.btThread = btThread;
        this.addCommand(CANCEL_CMD);
        this.setCommandListener(this);
    }

    public void doUpdate(Observable o, Object arg) {
        if (arg == null) {
            this.addCommand(RESTART_CMD);
        } else {
            this.append((String)arg, null);
            if (this.size() == 1) {
                this.addCommand(OK_CMD);
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c.equals(CANCEL_CMD)) {
            this.btThread.finish();
            this.midlet.pacmanMenuBack();
        } else if (c.equals(OK_CMD)) {
            int index = this.getSelectedIndex();
            if (index != -1) {
                this.btThread.finish();
                this.midlet.pacmanNewMultiplayerClient(this.btThread.getServiceRecord(index));
            }
        } else if (c.equals(RESTART_CMD)) {
            this.removeCommand(RESTART_CMD);
            this.removeCommand(OK_CMD);
            this.deleteAll();
            this.btThread.start();
        }
    }
}

