/*
 * Decompiled with CFR 0.152.
 */
package multipacman;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import multipacman.PacmanMIDlet;

class ChooseLevelMenu
extends List
implements CommandListener {
    private static final String title = "Pac-Man";
    private final String path;
    private final String ending;
    private PacmanMIDlet midlet;
    private Command backCommand;
    private Command startCommand;
    private int levelCount = 0;

    public ChooseLevelMenu(PacmanMIDlet midlet) {
        super(title, 3);
        this.path = "/map/";
        this.ending = ".map";
        this.midlet = midlet;
        int nr = 1;
        InputStream is = null;
        do {
            String fullPath = "/map/" + nr + ".map";
            is = ((Object)((Object)this)).getClass().getResourceAsStream(fullPath);
            if (is != null) {
                ++this.levelCount;
                DataInputStream dis = new DataInputStream(is);
                StringBuffer buffer = new StringBuffer();
                try {
                    char c;
                    while (dis.available() > 0 && (c = (char)dis.read()) != '\n') {
                        buffer.append(c);
                    }
                    is.close();
                    dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.append(buffer.toString(), null);
            }
            ++nr;
        } while (is != null);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.startCommand = new Command("Start", 4, 1);
        this.addCommand(this.startCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.midlet.pacmanMenuBack();
        } else if (c == this.startCommand || c == List.SELECT_COMMAND) {
            this.midlet.loadLevel(this.getSelectedIndex() + 1 + ".map");
            this.midlet.startNewGame();
        }
    }
}

