/*
 * Decompiled with CFR 0.152.
 */
package examples.sensor;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class SensorBrowser
extends MIDlet
implements CommandListener,
ItemStateListener,
DataListener {
    private static final Command CMD_LIST_DETAIL = new Command("Detail", 8, 1);
    private static final Command CMD_EXIT = new Command("Exit", 7, 1);
    private static final Command CMD_BACK = new Command("Back", 2, 1);
    private SensorInfo[] sensorInfos;
    private Display display = Display.getDisplay((MIDlet)this);
    private List sensorsList = new List("Sensors list:", 1);
    private Form sensorDetail;
    private ChoiceGroup channelsChoiceGroup;
    private int currentSensorId;
    private int channelIndex;
    private StringItem currentChannelValue;
    private SensorConnection sensorConnection;

    public SensorBrowser() {
        this.sensorInfos = SensorManager.findSensors(null, null);
        for (int k = 0; k < this.sensorInfos.length; ++k) {
            this.sensorsList.append(this.constructVisibleSensorName(this.sensorInfos[k]), null);
        }
        this.sensorsList.addCommand(CMD_LIST_DETAIL);
        this.sensorsList.addCommand(CMD_EXIT);
        this.sensorsList.setCommandListener((CommandListener)this);
    }

    protected void destroyApp(boolean bl) {
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        this.display.setCurrent((Displayable)this.sensorsList);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable.equals(this.sensorsList)) {
            if (CMD_LIST_DETAIL == command) {
                this.currentSensorId = this.sensorsList.getSelectedIndex();
                this.createSensorDetail();
                this.display.setCurrent((Displayable)this.sensorDetail);
                this.startMeasuring();
            } else if (CMD_EXIT == command) {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        } else if (displayable.equals(this.sensorDetail) && CMD_BACK == command) {
            this.stopMeasuring();
            this.display.setCurrent((Displayable)this.sensorsList);
        }
    }

    private void startMeasuring() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SensorBrowser sensorBrowser = SensorBrowser.this;
                synchronized (sensorBrowser) {
                    try {
                        SensorBrowser.this.sensorConnection = (SensorConnection)Connector.open((String)SensorBrowser.this.sensorInfos[SensorBrowser.this.currentSensorId].getUrl());
                        SensorBrowser.this.sensorConnection.setDataListener(SensorBrowser.this, 1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private synchronized void stopMeasuring() {
        if (this.sensorConnection != null) {
            try {
                this.sensorConnection.removeDataListener();
                this.sensorConnection.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.sensorConnection = null;
        }
    }

    public void itemStateChanged(Item item) {
        if (item.equals(this.channelsChoiceGroup)) {
            this.channelIndex = this.channelsChoiceGroup.getSelectedIndex();
            this.deleteChannelInfoForm();
            this.insertChannelInfoForm(this.sensorInfos[this.currentSensorId].getChannelInfos()[this.channelIndex]);
        }
    }

    private void createSensorDetail() {
        SensorInfo sensorInfo = this.sensorInfos[this.currentSensorId];
        this.sensorDetail = new Form("Sensor detail: " + this.constructVisibleSensorName(sensorInfo));
        this.sensorDetail.append((Item)new StringItem("Quantity:", sensorInfo.getQuantity(), 1));
        this.sensorDetail.append((Item)new StringItem("Model:", sensorInfo.getModel(), 1));
        this.sensorDetail.append((Item)new StringItem("Context type:", sensorInfo.getContextType(), 1));
        this.sensorDetail.append((Item)new StringItem("Connection type:", this.connectionTypeToString(sensorInfo.getConnectionType())));
        this.sensorDetail.append((Item)new StringItem("URL:", sensorInfo.getUrl(), 1));
        this.sensorDetail.append((Item)new StringItem("Description:", sensorInfo.getDescription(), 1));
        String[] stringArray = sensorInfo.getPropertyNames();
        for (int k = 0; k < stringArray.length; ++k) {
            Object object = sensorInfo.getProperty(stringArray[k]);
            this.sensorDetail.append((Item)new StringItem(stringArray[k] + ":", object.toString(), 1));
        }
        this.channelsChoiceGroup = new ChoiceGroup("Channel:", 4);
        this.sensorDetail.append((Item)this.channelsChoiceGroup);
        this.sensorDetail.setItemStateListener((ItemStateListener)this);
        ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
        for (int k = 0; k < channelInfoArray.length; ++k) {
            this.channelsChoiceGroup.append(channelInfoArray[k].getName(), null);
        }
        this.channelIndex = 0;
        ChannelInfo channelInfo = channelInfoArray[this.channelIndex];
        this.insertChannelInfoForm(channelInfo);
        this.sensorDetail.addCommand(CMD_BACK);
        this.sensorDetail.setCommandListener((CommandListener)this);
    }

    private String connectionTypeToString(int n) {
        switch (n) {
            case 1: {
                return "embedded";
            }
            case 2: {
                return "remote";
            }
            case 4: {
                return "short range wireless";
            }
            case 8: {
                return "wired";
            }
        }
        return "unknown";
    }

    private String dataTypeToString(int n) {
        switch (n) {
            case 1: {
                return "double";
            }
            case 2: {
                return "integer";
            }
            case 4: {
                return "object";
            }
        }
        return "unknown";
    }

    private String constructVisibleSensorName(SensorInfo sensorInfo) {
        return sensorInfo.getQuantity() + " (" + sensorInfo.getModel() + ";" + sensorInfo.getContextType() + ")";
    }

    private void deleteChannelInfoForm() {
        int n;
        for (n = 0; n < this.sensorDetail.size() && !this.channelsChoiceGroup.equals(this.sensorDetail.get(n)); ++n) {
        }
        ++n;
        while (n < this.sensorDetail.size()) {
            this.sensorDetail.delete(n);
        }
    }

    private void insertChannelInfoForm(ChannelInfo channelInfo) {
        this.currentChannelValue = new StringItem("Current Value:", "unknown", 1);
        this.sensorDetail.append((Item)this.currentChannelValue);
        this.sensorDetail.append((Item)new StringItem("Unit:", channelInfo.getUnit().toString(), 1));
        this.sensorDetail.append((Item)new StringItem("Scale:", String.valueOf(channelInfo.getScale()), 1));
        this.sensorDetail.append((Item)new StringItem("Data type:", this.dataTypeToString(channelInfo.getDataType()), 1));
        this.sensorDetail.append((Item)new StringItem("Accuracy:", String.valueOf(channelInfo.getAccuracy()), 1));
        MeasurementRange[] measurementRangeArray = channelInfo.getMeasurementRanges();
        for (int k = 0; k < measurementRangeArray.length; ++k) {
            this.sensorDetail.append((Item)new StringItem("Range[" + k + "]:", "<" + String.valueOf(measurementRangeArray[k].getSmallestValue()) + "; " + String.valueOf(measurementRangeArray[k].getLargestValue()) + "> resolution:" + measurementRangeArray[k].getResolution(), 1));
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] dataArray, boolean bl) {
        int n = dataArray[this.channelIndex].getChannelInfo().getDataType();
        if (1 == n) {
            this.currentChannelValue.setText(String.valueOf(dataArray[this.channelIndex].getDoubleValues()[0]));
        } else if (2 == n) {
            this.currentChannelValue.setText(String.valueOf(dataArray[this.channelIndex].getIntValues()[0]));
        } else if (4 == n) {
            this.currentChannelValue.setText("object");
        }
    }
}

