/*
 * Decompiled with CFR 0.152.
 */
package examples.sensor;

import examples.sensor.Vector;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Player;

public class MarblesWall
extends Canvas
implements Runnable {
    private static final double G_CONST = 10.0;
    private static final double PPCM = 30.0;
    private static final long TICK_SLEEP_MILLIS = 1L;
    static final double ROLLING_FRICTION = 0.09;
    static final double BALL_MASS = 9.42179E-4;
    static Random random = new Random();
    private final double accelMultX;
    private final double accelMultY;
    private final double accelMultZ;
    private Marble[] marble;
    private volatile boolean stop;
    private Player audioPlayer;
    private double accelX;
    private double accelY;
    private double accelZ;
    final int smooth;
    double[] avgX = new double[5];
    double[] avgY = new double[5];
    double[] avgZ = new double[5];

    public MarblesWall() throws IOException {
        this.smooth = 5;
        double d2 = 1000000.0;
        this.accelMultX = 30000.0 / d2;
        this.accelMultY = -30000.0 / d2;
        this.accelMultZ = 30000.0 / d2;
        this.marble = new Marble[6];
        this.marble[0] = new Marble((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.5, 0);
        this.marble[1] = new Marble((double)this.getWidth() * 0.25, (double)this.getHeight() * 0.5, 1);
        this.marble[2] = new Marble((double)this.getWidth() * 0.75, (double)this.getHeight() * 0.5, 2);
        this.marble[3] = new Marble((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.25, 3);
        this.marble[4] = new Marble((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.75, 4);
        this.stop = false;
        this.marble[5] = new Marble(this.getWidth() - 10, this.getHeight() - 30, 5);
        this.marble[5].stopb = true;
        new Thread(this).start();
    }

    public synchronized void resetBoard() {
        this.accelX = 0.0;
        this.accelY = 0.0;
        this.marble[0].resetPosition((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.5);
        this.marble[1].resetPosition((double)this.getWidth() * 0.25, (double)this.getHeight() * 0.5);
        this.marble[2].resetPosition((double)this.getWidth() * 0.75, (double)this.getHeight() * 0.5);
        this.marble[3].resetPosition((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.25);
        this.marble[4].resetPosition((double)this.getWidth() * 0.5, (double)this.getHeight() * 0.75);
        this.marble[5].resetPosition(this.getWidth() - 10, this.getHeight() - 30);
    }

    public void keyPressed(int n) {
        switch (n) {
            case 49: {
                this.marble[4].stopb = true;
                break;
            }
            case 48: {
                this.marble[3].stopb = true;
                break;
            }
            case 50: {
                this.marble[2].stopb = true;
                break;
            }
            case 53: {
                this.marble[1].stopb = true;
            }
        }
        this.repaint();
    }

    public void stop() {
        this.stop = true;
    }

    public void run() {
        try {
            while (!this.stop) {
                this.calculatePositions();
                this.repaint();
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xEFEFEF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int k = 0; k < this.marble.length; ++k) {
            this.marble[k].paint(graphics);
        }
    }

    public synchronized void accelerate(double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        for (int k = 0; k < this.avgX.length - 1; ++k) {
            d5 += this.avgX[k];
            d6 += this.avgY[k];
            d7 += this.avgZ[k];
            this.avgX[k] = this.avgX[k + 1];
            this.avgY[k] = this.avgY[k + 1];
            this.avgZ[k] = this.avgZ[k + 1];
        }
        this.avgX[this.avgX.length - 1] = d2;
        this.avgY[this.avgY.length - 1] = d3;
        this.avgZ[this.avgZ.length - 1] = d4;
        this.accelX = (d5 /= (double)(this.avgX.length + 1)) * this.accelMultX;
        this.accelY = (d6 /= (double)(this.avgY.length + 1)) * this.accelMultY;
        this.accelZ = (d7 /= (double)(this.avgZ.length + 1)) * this.accelMultZ;
    }

    private synchronized void calculatePositions() {
        int n;
        for (n = 0; n < this.marble.length; ++n) {
            if (this.marble[n].stopb) continue;
            this.marble[n].accelerate(this.accelX, this.accelY, this.accelZ);
            this.marble[n].collideBorders(this);
        }
        for (n = 0; n < this.marble.length; ++n) {
            for (int k = n + 1; k < this.marble.length; ++k) {
                if (this.marble[n].stopb && this.marble[k].stopb) continue;
                this.marble[n].collide(this.marble[k]);
            }
        }
        for (n = 0; n < this.marble.length; ++n) {
            if (this.marble[n].stopb) continue;
            this.marble[n].calcNewPosition();
        }
    }

    static class Marble {
        private Image img;
        private Vector pos;
        private Vector speed;
        public boolean stopb = false;
        private double bounceFriction;
        private double radius;

        public Marble(double d2, double d3, int n) throws IOException {
            switch (n) {
                case 0: {
                    this.img = Image.createImage((String)"/black_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                case 1: {
                    this.img = Image.createImage((String)"/red_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                case 2: {
                    this.img = Image.createImage((String)"/green_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                case 3: {
                    this.img = Image.createImage((String)"/yellow_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                case 4: {
                    this.img = Image.createImage((String)"/red_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                default: {
                    this.img = Image.createImage((String)"/box.gif");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.9;
                }
            }
        }

        public void resetPosition(double d2, double d3) {
            this.speed = new Vector(0.0, 0.0);
            this.pos.setX(d2 - this.getRadius());
            this.pos.setY(d3 - this.getRadius());
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.img, (int)this.pos.getX(), (int)this.pos.getY(), 3);
        }

        public void accelerate(double d2, double d3, double d4) {
            double d5 = Math.max(0.0, d4) * 0.09 * 9.42179E-4;
            this.speed.add(new Vector(d2, d3));
            if (this.speed.getX() > 0.0) {
                this.speed.setX(this.speed.getX() - Math.min(this.speed.getX(), d5));
            } else if (this.speed.getX() < 0.0) {
                this.speed.setX(this.speed.getX() + Math.min(-this.speed.getX(), d5));
            }
            if (this.speed.getY() > 0.0) {
                this.speed.setY(this.speed.getY() - Math.min(this.speed.getY(), d5));
            } else if (this.speed.getY() < 0.0) {
                this.speed.setY(this.speed.getY() + Math.min(-this.speed.getY(), d5));
            }
        }

        public void calcNewPosition() {
            this.pos.add(this.speed);
        }

        public double getRadius() {
            return this.radius;
        }

        public void collideBorders(Canvas canvas) {
            Vector vector = Vector.add(this.pos, this.speed);
            if (vector.getY() - this.getRadius() < 0.0) {
                this.speed.setY(this.speed.getY() * (this.bounceFriction - 1.0));
                this.pos.setY(this.getRadius());
            } else if (vector.getY() + this.getRadius() > (double)canvas.getHeight()) {
                this.speed.setY(this.speed.getY() * (this.bounceFriction - 1.0));
                this.pos.setY((double)canvas.getHeight() - this.getRadius());
            }
            if (vector.getX() - this.getRadius() < 0.0) {
                this.speed.setX(this.speed.getX() * (this.bounceFriction - 1.0));
                this.pos.setX(this.getRadius());
            } else if (vector.getX() + this.getRadius() > (double)canvas.getWidth()) {
                this.speed.setX(this.speed.getX() * (this.bounceFriction - 1.0));
                this.pos.setX((double)canvas.getWidth() - this.getRadius());
            }
        }

        public void collide(Marble marble) {
            double d2;
            double d3 = this.getRadius() * 2.0;
            double d4 = this.pos.getX() + this.speed.getX();
            double d5 = this.pos.getY() + this.speed.getY();
            double d6 = marble.pos.getX() + marble.speed.getX();
            if ((d4 - d6) * (d4 - d6) + (d5 - (d2 = marble.pos.getY() + marble.speed.getY())) * (d5 - d2) < d3 * d3) {
                Vector vector = new Vector(this.speed);
                Vector vector2 = new Vector(marble.speed);
                Vector vector3 = new Vector(d4, d5);
                Vector vector4 = new Vector(d6, d2);
                Vector vector5 = Vector.sub(vector4, vector3).norm();
                Vector vector6 = Vector.mul(vector5, Vector.dot(vector5, vector));
                Vector vector7 = Vector.sub(vector, vector6);
                Vector vector8 = Vector.mul(vector5.inv(), Vector.dot(vector5.inv(), vector2));
                Vector vector9 = Vector.sub(vector2, vector8);
                Vector vector10 = Vector.sub(Vector.add(vector6, vector8), Vector.sub(vector6, vector8));
                vector10.mul(0.5);
                Vector vector11 = Vector.sub(Vector.add(vector6, vector8), Vector.sub(vector8, vector6));
                vector11.mul(0.5);
                Vector vector12 = vector7;
                Vector vector13 = vector9;
                Vector vector14 = Vector.add(vector10, vector12);
                Vector vector15 = Vector.add(vector11, vector13);
                this.speed = new Vector(vector14.getX(), vector14.getY());
                marble.speed = new Vector(vector15.getX(), vector15.getY());
            }
        }
    }
}

