/*
 * Decompiled with CFR 0.152.
 */
package examples.sensor;

import examples.sensor.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MarblesBoard
extends Canvas
implements Runnable {
    private static final double G_CONST = 5.0;
    private static final double PPCM = 30.0;
    private static final long TICK_SLEEP_MILLIS = 1L;
    static final double ROLLING_FRICTION = 0.09;
    static final double BALL_MASS = 9.42179E-4;
    static Random random = new Random();
    private final double accelMultX;
    private final double accelMultY;
    private final double accelMultZ;
    private static int score = 0;
    private static int level = 6;
    private static int aniIndex = 0;
    private String status = "Score: 0";
    private String theTime = "Time Left: 120";
    private Marble[] marble;
    private Marble[] touchMarble;
    private volatile boolean stop;
    private volatile boolean gameOver = false;
    private Player player;
    private static Player player2;
    private double accelX;
    private double accelY;
    private double accelZ;
    Image[] twistAni = new Image[2];
    Timer timer = new Timer();
    long target = 121000L + System.currentTimeMillis();
    Task0 task = new Task0(this.target);
    final int smooth;
    double[] avgX = new double[5];
    double[] avgY = new double[5];
    double[] avgZ = new double[5];

    public MarblesBoard() throws IOException {
        this.smooth = 5;
        try {
            this.twistAni[0] = Image.createImage((String)"/twister_black.png");
            this.twistAni[1] = Image.createImage((String)"/twister3.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d2 = 1000000.0;
        this.accelMultX = 15000.0 / d2;
        this.accelMultY = -15000.0 / d2;
        this.accelMultZ = 15000.0 / d2;
        this.marble = new Marble[level];
        int n = 120;
        this.marble[0] = new Marble((double)this.getWidth() * 0.5, this.getHeight() - 30, 0);
        this.marble[1] = new Marble(21.0, 300.0, 1);
        this.marble[2] = new Marble(21.0, 320.0, 2);
        this.marble[3] = new Marble(21.0, 340.0, 3);
        this.marble[4] = new Marble(21.0, 360.0, 4);
        this.stop = false;
        for (int k = 1; k < 5; ++k) {
            this.marble[k].stopb = true;
        }
        this.marble[5] = new Marble(120.0, 90.0, 5);
        this.marble[5].stopb = true;
        this.timer.schedule((TimerTask)this.task, 0L, 1000L);
        new Thread(this).start();
    }

    public synchronized void resetBoard() {
        this.accelX = 0.0;
        this.accelY = 0.0;
        int n = 20;
        score = 0;
        this.marble[0].resetPosition((double)this.getWidth() * 0.5, this.getHeight() - 30);
        this.marble[1].resetPosition(21.0, 300.0);
        this.marble[2].resetPosition(21.0, 320.0);
        this.marble[3].resetPosition(21.0, 340.0);
        this.marble[4].resetPosition(21.0, 360.0);
        this.stop = false;
        this.marble[0].stopb = false;
        for (int k = 1; k < 5; ++k) {
            this.marble[k].stopb = true;
        }
        this.marble[5].resetPosition(120.0, 90.0);
        this.gameOver = false;
        this.target = 121000L + System.currentTimeMillis();
        this.task.cancel();
        this.task = new Task0(this.target);
        this.timer.schedule((TimerTask)this.task, 0L, 1000L);
    }

    public void keyPressed(int n) {
        switch (n) {
            case 49: {
                this.marble[4].stopb = true;
                break;
            }
            case 48: {
                this.marble[3].stopb = true;
                break;
            }
            case 50: {
                this.marble[2].stopb = true;
                break;
            }
            case 53: {
                this.marble[1].stopb = true;
            }
        }
        this.repaint();
    }

    public void stop() {
        this.stop = true;
    }

    public void run() {
        try {
            block6: {
                try {
                    Class<?> clazz = this.getClass();
                    InputStream inputStream = clazz.getResourceAsStream("/audio/hit.wav");
                    player2 = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
                    player2.stop();
                    player2.prefetch();
                    String string = "/audio/pattern.mid";
                    InputStream inputStream2 = this.getClass().getResourceAsStream(string);
                    String string2 = "audio/midi";
                    this.player = Manager.createPlayer((InputStream)inputStream2, (String)string2);
                    if (this.player != null) {
                        this.player.setLoopCount(-1);
                        this.player.start();
                    }
                }
                catch (Exception exception) {
                    if (this.player == null) break block6;
                    this.player.close();
                    this.player = null;
                }
            }
            while (!this.stop) {
                this.calculatePositions();
                this.calculateScores();
                this.repaint();
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xEFEFEF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int k = 0; k < this.marble.length; ++k) {
            this.marble[k].paint(graphics);
            graphics.setColor(0xCC0000);
            graphics.drawString(this.status, 0, 10, 20);
            graphics.setColor(0);
            graphics.drawRect(11, 250, 22, 125);
        }
        graphics.setColor(0);
        graphics.drawString(this.theTime, 130, 10, 20);
        if (aniIndex == 0) {
            graphics.drawImage(this.twistAni[aniIndex], 120, 90, 1 | 2);
            aniIndex = 1;
        } else {
            graphics.drawImage(this.twistAni[aniIndex], 120, 90, 1 | 2);
            aniIndex = 0;
        }
        if (this.gameOver) {
            graphics.setColor(0);
            graphics.drawString("Times up... Game Over!!", 40, 140, 20);
            graphics.drawString("Your Score: " + score, 80, 160, 20);
            String string = new String("John,3400");
            byte[] byArray = string.getBytes();
            for (int k = 0; k < 5; ++k) {
                this.marble[k].stopb = true;
            }
        }
    }

    public synchronized void accelerate(double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        for (int k = 0; k < this.avgX.length - 1; ++k) {
            d5 += this.avgX[k];
            d6 += this.avgY[k];
            d7 += this.avgZ[k];
            this.avgX[k] = this.avgX[k + 1];
            this.avgY[k] = this.avgY[k + 1];
            this.avgZ[k] = this.avgZ[k + 1];
        }
        this.avgX[this.avgX.length - 1] = d2;
        this.avgY[this.avgY.length - 1] = d3;
        this.avgZ[this.avgZ.length - 1] = d4;
        this.accelX = (d5 /= (double)(this.avgX.length + 1)) * this.accelMultX;
        this.accelY = (d6 /= (double)(this.avgY.length + 1)) * this.accelMultY;
        this.accelZ = (d7 /= (double)(this.avgZ.length + 1)) * this.accelMultZ;
    }

    public void pointerPressed(int n, int n2) {
        System.out.println("X & " + n + n2);
    }

    public void pointerDragged(int n, int n2) {
        System.out.println("old X & Old Y " + n + n2);
    }

    private synchronized void calculatePositions() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.marble.length; ++n2) {
            if (this.marble[n2].stopb) continue;
            this.marble[n2].accelerate(this.accelX, this.accelY, this.accelZ);
            this.marble[n2].collideBorders(this);
        }
        for (n2 = 0; n2 < this.marble.length - 1; ++n2) {
            for (n = n2 + 1; n < this.marble.length - 1; ++n) {
                this.marble[n2].collide(this.marble[n]);
            }
        }
        for (n2 = 0; n2 < this.marble.length; ++n2) {
            for (n = n2 + 1; n < this.marble.length; ++n) {
                this.marble[n2].compScore(this.marble[5]);
            }
        }
        for (n2 = 0; n2 < this.marble.length; ++n2) {
            if (this.marble[n2].stopb) continue;
            this.marble[n2].calcNewPosition();
        }
    }

    private synchronized void calculateScores() {
        this.status = "Score:" + score;
        if (score > 1000 && !this.gameOver) {
            this.marble[1].stopb = false;
        }
        if (score > 2500 && !this.gameOver) {
            this.marble[1].stopb = false;
            this.marble[2].stopb = false;
        }
        if (score > 4000 && !this.gameOver) {
            this.marble[1].stopb = false;
            this.marble[2].stopb = false;
            this.marble[3].stopb = false;
            this.marble[4].stopb = false;
        }
    }

    private void theTimer(String string) {
        this.theTime = string;
        this.repaint();
        this.serviceRepaints();
    }

    static class Marble {
        private Image img;
        private Vector pos;
        private Vector speed;
        public boolean stopb = false;
        public boolean validball = false;
        private double bounceFriction;
        private double radius;

        public Marble(double d2, double d3, int n) throws IOException {
            switch (n) {
                case 0: {
                    this.img = Image.createImage((String)"/green_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.validball = true;
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.2;
                    break;
                }
                case 1: {
                    this.img = Image.createImage((String)"/yellow_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.3;
                    break;
                }
                case 2: {
                    this.img = Image.createImage((String)"/green_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.validball = true;
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.3;
                    break;
                }
                case 3: {
                    this.img = Image.createImage((String)"/black_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.3;
                    break;
                }
                case 4: {
                    this.img = Image.createImage((String)"/red_marble.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.3;
                    break;
                }
                default: {
                    this.img = Image.createImage((String)"/twister_black.png");
                    this.pos = new Vector(d2, d3);
                    this.speed = new Vector(0.0, 0.0);
                    this.radius = (double)this.img.getWidth() / 2.0;
                    this.bounceFriction = 0.3;
                }
            }
        }

        public void resetPosition(double d2, double d3) {
            this.speed = new Vector(0.0, 0.0);
            this.pos = new Vector(d2, d3);
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.img, (int)this.pos.getX(), (int)this.pos.getY(), 3);
        }

        public void accelerate(double d2, double d3, double d4) {
            double d5 = Math.max(0.0, d4) * 0.09 * 9.42179E-4;
            this.speed.add(new Vector(d2, d3));
            if (this.speed.getX() > 0.0) {
                this.speed.setX(this.speed.getX() - Math.min(this.speed.getX(), d5));
            } else if (this.speed.getX() < 0.0) {
                this.speed.setX(this.speed.getX() + Math.min(-this.speed.getX(), d5));
            }
            if (this.speed.getY() > 0.0) {
                this.speed.setY(this.speed.getY() - Math.min(this.speed.getY(), d5));
            } else if (this.speed.getY() < 0.0) {
                this.speed.setY(this.speed.getY() + Math.min(-this.speed.getY(), d5));
            }
        }

        public void calcNewPosition() {
            this.pos.add(this.speed);
        }

        public double getRadius() {
            return this.radius;
        }

        public void play() {
            try {
                player2.start();
            }
            catch (Exception exception) {
                System.out.println("ERROR -> " + exception);
            }
        }

        public void collideBorders(Canvas canvas) {
            Vector vector = Vector.add(this.pos, this.speed);
            if (vector.getY() - this.getRadius() < 0.0) {
                this.speed.setY(this.speed.getY() * (this.bounceFriction - 1.0));
                this.pos.setY(this.getRadius());
            } else if (vector.getY() + this.getRadius() > (double)canvas.getHeight()) {
                this.speed.setY(this.speed.getY() * (this.bounceFriction - 1.0));
                this.pos.setY((double)canvas.getHeight() - this.getRadius());
            }
            if (vector.getX() - this.getRadius() < 0.0) {
                this.speed.setX(this.speed.getX() * (this.bounceFriction - 1.0));
                this.pos.setX(this.getRadius());
            } else if (vector.getX() + this.getRadius() > (double)canvas.getWidth()) {
                this.speed.setX(this.speed.getX() * (this.bounceFriction - 1.0));
                this.pos.setX((double)canvas.getWidth() - this.getRadius());
            }
        }

        public void collide(Marble marble) {
            double d2;
            double d3 = this.getRadius() * 2.0;
            double d4 = this.pos.getX() + this.speed.getX();
            double d5 = this.pos.getY() + this.speed.getY();
            double d6 = marble.pos.getX() + marble.speed.getX();
            if ((d4 - d6) * (d4 - d6) + (d5 - (d2 = marble.pos.getY() + marble.speed.getY())) * (d5 - d2) < d3 * d3) {
                Vector vector = new Vector(this.speed);
                Vector vector2 = new Vector(marble.speed);
                Vector vector3 = new Vector(d4, d5);
                Vector vector4 = new Vector(d6, d2);
                Vector vector5 = Vector.sub(vector4, vector3).norm();
                Vector vector6 = Vector.mul(vector5, Vector.dot(vector5, vector));
                Vector vector7 = Vector.sub(vector, vector6);
                Vector vector8 = Vector.mul(vector5.inv(), Vector.dot(vector5.inv(), vector2));
                Vector vector9 = Vector.sub(vector2, vector8);
                Vector vector10 = Vector.sub(Vector.add(vector6, vector8), Vector.sub(vector6, vector8));
                vector10.mul(0.5);
                Vector vector11 = Vector.sub(Vector.add(vector6, vector8), Vector.sub(vector8, vector6));
                vector11.mul(0.5);
                Vector vector12 = vector7;
                Vector vector13 = vector9;
                Vector vector14 = Vector.add(vector10, vector12);
                Vector vector15 = Vector.add(vector11, vector13);
                this.speed = new Vector(vector14.getX(), vector14.getY());
                marble.speed = new Vector(vector15.getX(), vector15.getY());
            }
        }

        public void compScore(Marble marble) {
            int n = (int)this.pos.getX();
            int n2 = (int)this.pos.getY();
            if (n >= 112 && n <= 132 && n2 >= 82 && n2 <= 102) {
                if (this.validball) {
                    score += 10;
                } else if (score > 0) {
                    score -= 3;
                }
            }
        }
    }

    class Task0
    extends TimerTask {
        long targ;
        private int n = Integer.MAX_VALUE;

        Task0(long l) {
            this.targ = l;
        }

        public void run() {
            System.out.println("remaining seconds:");
            this.n = (int)((this.targ - System.currentTimeMillis()) / 1000L);
            System.out.println(String.valueOf(this.n));
            MarblesBoard.this.theTimer("Time Left: " + this.n);
            if (this.n <= 0) {
                System.out.println("Time is up!");
                MarblesBoard.this.gameOver = true;
                MarblesBoard.this.repaint();
                this.cancel();
            }
        }
    }
}

