/*
 * Decompiled with CFR 0.152.
 */
package examples.sensor;

import examples.sensor.MarblesBoard;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class Marbles
extends MIDlet
implements DataListener,
CommandListener {
    private static final Command CMD_NEW_GAME = new Command("Play", 1, 1);
    private static final Command CMD_EXIT = new Command("Exit", 7, 1);
    private final MarblesBoard marblesBoard;
    private SensorConnection sensor;
    private String[] channelNames;
    private boolean sensorSelected;
    private List sensorSelector;
    private SensorInfo[] sensorInfos;

    public Marbles() throws IOException {
        if (System.getProperty("microedition.sensor.version") == null) {
            throw new IllegalArgumentException("JSR256 is not supported!");
        }
        this.marblesBoard = new MarblesBoard();
        this.marblesBoard.addCommand(CMD_EXIT);
        this.marblesBoard.addCommand(CMD_NEW_GAME);
        this.marblesBoard.setCommandListener(this);
        this.sensorInfos = this.getSensorInfos();
        if (this.sensorInfos == null) {
            throw new IllegalArgumentException("Valid accelerometer sensor not found");
        }
        this.sensorSelector = new List("Select accelerometer:", 1);
        for (int k = 0; k < this.sensorInfos.length; ++k) {
            this.sensorSelector.append(this.sensorInfos[k].getUrl(), null);
        }
        this.sensorSelector.addCommand(CMD_EXIT);
        this.sensorSelector.addCommand(CMD_NEW_GAME);
        this.sensorSelector.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        if (!this.sensorSelected) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sensorSelector);
        } else {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.marblesBoard);
            this.sensor.setDataListener(this, 1);
        }
    }

    public void pauseApp() {
        this.sensor.removeDataListener();
    }

    public void destroyApp(boolean bl) {
        if (this.sensor != null) {
            try {
                this.sensor.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable.equals(this.marblesBoard)) {
            if (CMD_NEW_GAME.equals(command)) {
                this.marblesBoard.resetBoard();
            } else if (CMD_EXIT.equals(command)) {
                this.marblesBoard.stop();
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        } else if (displayable.equals(this.sensorSelector)) {
            if (CMD_NEW_GAME.equals(command)) {
                new Thread(){

                    public void run() {
                        int n = Marbles.this.sensorSelector.getSelectedIndex();
                        Marbles.access$102(Marbles.this, Marbles.this.getSensorInfoChannelsNames(Marbles.this.sensorInfos[n]));
                        try {
                            Marbles.this.sensor = (SensorConnection)Connector.open((String)Marbles.this.sensorInfos[n].getUrl());
                            Marbles.this.sensorSelected = true;
                            Display.getDisplay((MIDlet)Marbles.this).setCurrent((Displayable)Marbles.this.marblesBoard);
                            Marbles.this.sensor.setDataListener(Marbles.this, 1);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }.start();
            } else if (CMD_EXIT.equals(command)) {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] dataArray, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int k = 0; k < dataArray.length; ++k) {
            if (this.channelNames[0].equals(dataArray[k].getChannelInfo().getName())) {
                d2 = dataArray[k].getDoubleValues()[0];
                switch (dataArray[k].getChannelInfo().getScale()) {
                    case -3: {
                        d2 /= 10.0;
                    }
                    case -2: {
                        d2 /= 10.0;
                    }
                    case -1: {
                        d2 /= 10.0;
                    }
                }
                continue;
            }
            if (this.channelNames[1].equals(dataArray[k].getChannelInfo().getName())) {
                d3 = dataArray[k].getDoubleValues()[0];
                switch (dataArray[k].getChannelInfo().getScale()) {
                    case -3: {
                        d3 /= 10.0;
                    }
                    case -2: {
                        d3 /= 10.0;
                    }
                    case -1: {
                        d3 /= 10.0;
                    }
                }
                continue;
            }
            if (!this.channelNames[2].equals(dataArray[k].getChannelInfo().getName())) continue;
            d4 = dataArray[k].getDoubleValues()[0];
            switch (dataArray[k].getChannelInfo().getScale()) {
                case -3: {
                    d4 /= 10.0;
                }
                case -2: {
                    d4 /= 10.0;
                }
                case -1: {
                    d4 /= 10.0;
                }
            }
        }
        this.marblesBoard.accelerate(d2, d3, d4);
    }

    private SensorInfo[] getSensorInfos() {
        SensorInfo[] sensorInfoArray = SensorManager.findSensors("acceleration", "device");
        Vector<SensorInfo> vector = new Vector<SensorInfo>();
        for (int k = 0; k < sensorInfoArray.length; ++k) {
            if (this.getSensorInfoChannelsNames(sensorInfoArray[k]) == null) continue;
            vector.addElement(sensorInfoArray[k]);
        }
        Object[] objectArray = null;
        if (vector.size() > 0) {
            objectArray = new SensorInfo[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private String[] getSensorInfoChannelsNames(SensorInfo sensorInfo) {
        Vector<String> vector = new Vector<String>();
        ChannelInfo[] channelInfoArray = sensorInfo.getChannelInfos();
        if (channelInfoArray.length > 1) {
            for (int k = 0; k < channelInfoArray.length; ++k) {
                if (1 != channelInfoArray[k].getDataType()) continue;
                vector.addElement(channelInfoArray[k].getName());
            }
            if (vector.size() > 2) {
                String[] stringArray = new String[]{(String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2)};
                return stringArray;
            }
        }
        return null;
    }

    static /* synthetic */ String[] access$102(Marbles marbles, String[] stringArray) {
        marbles.channelNames = stringArray;
        return stringArray;
    }
}

