/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.security;

import com.nokia.phone.sdk.concept.gateway.MEMirrorConnectionPool;
import com.nokia.phone.sdk.concept.gateway.mirror.MirrorConnection;
import com.nokia.phone.sdk.concept.gateway.mirror.MirrorInputStream;
import com.nokia.phone.sdk.concept.gateway.mirror.MirrorOutputStream;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.security.SecurityToken;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Permissions {
    private static MEMirrorConnectionPool pool = MEMirrorConnectionPool.getInstance();
    private static String CONFIGURATION_PATH = "com.nokia.phone.sdk.concept.mirrors.ConfigurationMirror";
    public static final String INTERNAL_DOMAIN_NAME = "internal";
    public static final String UNTRUSTED_DOMAIN_NAME = "untrusted";
    public static final String TRUSTED_DOMAIN_NAME = "trusted_3rd_party";
    public static final String MANUFACTURER_DOMAIN_NAME = "manufacturer";
    public static final String REAL_LIFE_DOMAIN_NAME = "real_life";
    private static final String CUSTOM_DOMAIN_NAME = "custom";
    private static final String MIMIMUM_DOMAIN_NAME = "minimum";
    private static String[] names = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "javax.microedition.io.Connector.http", "javax.microedition.io.Connector.https", "javax.microedition.io.Connector.datagram", "javax.microedition.io.Connector.datagramreceiver", "javax.microedition.io.Connector.socket", "javax.microedition.io.Connector.serversocket", "javax.microedition.io.Connector.ssl", "javax.microedition.io.Connector.comm", "javax.microedition.io.PushRegistry", "javax.wireless.messaging.sms.send", "javax.wireless.messaging.sms.receive", "javax.microedition.io.Connector.sms", "javax.wireless.messaging.cbs.receive", "javax.microedition.io.Connector.bluetooth.client", "javax.microedition.io.Connector.obex.client", "javax.microedition.io.Connector.obex.client.tcp", "javax.microedition.io.Connector.bluetooth.server", "javax.microedition.io.Connector.obex.server", "javax.microedition.io.Connector.obex.server.tcp", "javax.microedition.media.RecordControl.startRecord", "javax.microedition.media.VideoControl.getSnapshot", "javax.microedition.io.Connector.file.read", "javax.microedition.io.Connector.file.write", "javax.microedition.pim.ContactList.read", "javax.microedition.pim.EventList.read", "javax.microedition.pim.ToDoList.read", "javax.microedition.pim.ContactList.write", "javax.microedition.pim.EventList.write", "javax.microedition.pim.ToDoList.write", "javax.microedition.location.Location", "javax.microedition.location.Orientation", "javax.microedition.location.ProximityListener", "javax.microedition.location.LandmarkStore.read", "javax.microedition.location.LandmarkStore.write", "javax.microedition.location.LandmarkStore.category", "javax.microedition.location.LandmarkStore.management", "javax.microedition.sensor.PrivateSensor", "javax.microedition.sensor.ProtectedSensor"};
    static final String CLIENT_DIALOG_TITLE = "OK to Send Information?";
    static final String CLIENT_PERMISSION_QUESTION = "MIDlet wants to send information. Is this OK?";
    static final String SERVER_DIALOG_TITLE = "Connection Permissions";
    static final String SERVER_PERMISSION_QUESTION = "MIDlet wants to receive information. Is this OK?";
    private static String[] questions = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "MIDlet wants to send information. Is this OK?", "MIDlet wants to send information. Is this OK?", "MIDlet wants to send information. Is this OK?", "MIDlet wants to send information. Is this OK?", "MIDlet wants to receive information. Is this OK?", "MIDlet wants to send information. Is this OK?", "MIDlet wants to receive information. Is this OK?", "MIDlet wants to directly connect to a computer to exchange information. Is that OK?", "MIDlet wants to use auto invocation. Is that OK?", "MIDlet wants to send information using SMS. Is that OK?", "MIDlet wants to receive information using SMS. Is that OK?", "MIDlet wants to use SMS. Is that OK?", "MIDlet wants to receive information using CBS. Is that OK?", "MIDlet wants to open bluetooth client connection. Is that OK?", "MIDlet wants to open obex client connection. Is that OK?", "MIDlet wants to open obex client tcp connection. Is that OK?", "MIDlet wants to open bluetooth server connection. Is that OK?", "MIDlet wants to open obex server connection. Is that OK?", "MIDlet wants to open obex server tcp connection. Is that OK?", "MIDlet wants to start recording. Is that OK?", "MIDlet wants to get snapshot. Is that OK?", "MIDlet requests read file access. Is that OK?", "MIDlet requests write file access. Is that OK?", "The Midlet needs to read user data.", "The Midlet needs to read user data.", "The Midlet needs to read user data.", "The Midlet needs to write user data.", "The Midlet needs to write user data.", "The Midlet needs to write user data.", "MIDlet wants to get your location. Is that OK?", "MIDlet wants to get your orientation. Is that OK?", "MIDlet wants to listen to proximity events. Is that OK?", "MIDlet wants to read from your landmark database. Is that OK?", "MIDlet wants to write to your landmark database. Is that OK?", "MIDlet wants to add or delete a category. Is that OK?", "MIDlet wants to create or delete a landmark database. Is that OK?", "MIDlet wants to use a private sensor. Is that OK?", "MIDlet wants to use a proteceted sensor. Is that OK?"};
    private static String[] titles = new String[]{"com.sun.midp", "com.sun.midp.midletsuite.ams", "OK to Send Information?", "OK to Send Information?", "OK to Send Information?", "OK to Send Information?", "Connection Permissions", "OK to Send Information?", "Connection Permissions", "Connection Permissions:", "Push Permissions:", "SMS Permissions:", "SMS Permissions:", "SMS Permissions:", "CBS Permissions?", "Bluetooth Permissions:", "OK?", "OK?", "Bluetooth Permissions:", "OK To Start Server?", "OK To Start Server?", "Multimedia Recording?", "Multimedia Snapshot?", "File access permission:", "File access permission:", "PIM permission:", "PIM permission:", "PIM permission:", "PIM permission:", "PIM permission:", "PIM permission:", "OK to get location?", "OK to get orientation?", "OK to get proximity events?", "OK to read landmarks?", "OK to write landmarks?", "OK to modify landmark category?", "OK to modify landmark database?", "OK to use private sensor?", "OK to use protected sensor?"};
    public static final int MAX_LEVELS = 0;
    public static final int CUR_LEVELS = 1;
    public static final int MIDP = 0;
    public static final int AMS = 1;
    public static final int HTTP = 2;
    public static final int HTTPS = 3;
    public static final int UDP = 4;
    public static final int UDP_SERVER = 5;
    public static final int TCP = 6;
    public static final int TCP_SERVER = 7;
    public static final int SSL = 8;
    public static final int COMM = 9;
    public static final int PUSH = 10;
    public static final int SMS_SEND = 11;
    public static final int SMS_RECEIVE = 12;
    public static final int SMS = 13;
    public static final int CBS_RECEIVE = 14;
    public static final int BLUETOOTH_CLIENT = 15;
    public static final int OBEX_CLIENT = 16;
    public static final int OBEX_CLIENT_TCP = 17;
    public static final int BLUETOOTH_SERVER = 18;
    public static final int OBEX_SERVER = 19;
    public static final int OBEX_SERVER_TCP = 20;
    public static final int RECORDCONTROL_STARTRECORD = 21;
    public static final int RECORDCONTROL_GETSNAPSHOT = 22;
    public static final int FILE_READ = 23;
    public static final int FILE_WRITE = 24;
    public static final int CONTACTLIST_READ = 25;
    public static final int EVENTLIST_READ = 26;
    public static final int TODOLIST_READ = 27;
    public static final int CONTACTLIST_WRITE = 28;
    public static final int EVENTLIST_WRITE = 29;
    public static final int TODOLIST_WRITE = 30;
    public static final int GET_LOCATION = 31;
    public static final int GET_ORIENTATION = 32;
    public static final int LISTEN_PROXIMITY_EVENTS = 33;
    public static final int READ_LANDMARK_DATABASE = 34;
    public static final int WRITE_LANDMARK_DATABASE = 35;
    public static final int ADD_DELETE_CATEGORY = 36;
    public static final int ADD_DELETE_LANDMARK_DATABASE = 37;
    public static final int PRIVATE_SENSOR = 38;
    public static final int PROTECTED_SENSOR = 39;
    public static final int NUMBER_OF_PERMISSIONS = 40;
    public static final byte NEVER = 0;
    public static final byte ALLOW = 1;
    public static final byte BLANKET_GRANTED = 2;
    public static final byte BLANKET = 4;
    public static final byte SESSION = 8;
    public static final byte ONE_SHOT = 16;
    public static final byte DENY_SESSION = 32;
    public static final byte DENY = 64;
    public static final byte USER_DENIED = -128;
    private static boolean isRealLifeMode = false;
    private static Hashtable permissionsTable = null;

    public static String getName(int n) {
        if (n < 0 || n >= names.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return names[n];
    }

    public static String getTitle(int n) {
        if (n < 0 || n >= titles.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return titles[n];
    }

    public static String getQuestion(int n) {
        if (n < 0 || n >= questions.length) {
            throw new SecurityException("Application not authorized to access the restricted API");
        }
        return questions[n];
    }

    public static byte[][] forDomain(SecurityToken securityToken, String string) {
        byte[] byArray = new byte[40];
        byte[] byArray2 = new byte[40];
        byte[][] byArrayArray = new byte[][]{byArray, byArray2};
        if (INTERNAL_DOMAIN_NAME.equals(string)) {
            for (int k = 0; k < byArray.length; ++k) {
                byArray[k] = 1;
                byArray2[k] = 1;
            }
            return byArrayArray;
        }
        if (Permissions.getPermissions(securityToken, string, byArray, byArray2)) {
            return byArrayArray;
        }
        if (Permissions.getPermissions(securityToken, UNTRUSTED_DOMAIN_NAME, byArray, byArray2)) {
            return byArrayArray;
        }
        throw new SecurityException("untrusted domain is not configured");
    }

    public static byte[] getEmptySet() {
        byte[] byArray = new byte[40];
        Permissions.clearPerms(byArray);
        return byArray;
    }

    public static void setRealLifeMode(boolean bl) {
        isRealLifeMode = bl;
    }

    public static boolean isRealLife() {
        return isRealLifeMode;
    }

    private static Vector expandAlias(Vector vector, Hashtable hashtable) {
        boolean bl = false;
        if (hashtable == null || vector == null) {
            return vector;
        }
        Vector vector2 = new Vector(vector.size());
        for (int k = 0; k < vector.size(); ++k) {
            String string = (String)vector.elementAt(k);
            if (string.indexOf(46) == -1) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string.equals(string2)) continue;
                    Vector vector3 = (Vector)hashtable.get(string2);
                    for (int i2 = 0; i2 < vector3.size(); ++i2) {
                        vector2.addElement(vector3.elementAt(i2));
                    }
                    bl = true;
                    break;
                }
            }
            if (bl) {
                bl = false;
                continue;
            }
            vector2.addElement(string);
        }
        return vector2;
    }

    private static void clearPerms(byte[] byArray) {
        for (int k = 0; k < byArray.length; ++k) {
            byArray[k] = 0;
        }
    }

    private static int getPermIndex(String string) {
        for (int k = 0; k < names.length; ++k) {
            if (!names[k].equals(string)) continue;
            return k;
        }
        throw new IllegalArgumentException("bad API name: " + string);
    }

    private static void setPerms(byte[] byArray, Vector vector, byte by, byte by2) {
        for (int k = 0; k < vector.size(); ++k) {
            int n = Permissions.getPermIndex((String)vector.elementAt(k)) * 2;
            byArray[n] = by;
            byArray[n + 1] = by2;
        }
    }

    private static byte getPermFromString(String string) {
        if ("always_allowed".equals(string)) {
            return 1;
        }
        if ("ask_first_time".equals(string)) {
            return 4;
        }
        if ("not_allowed".equals(string)) {
            return 0;
        }
        if ("ask_everytime".equals(string)) {
            return 16;
        }
        throw new IllegalArgumentException("bad perm level: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getIntArray(String string, String string2) {
        MirrorConnection mirrorConnection = pool.getConnection(1);
        mirrorConnection.reserve();
        try {
            MirrorOutputStream mirrorOutputStream = mirrorConnection.getMirrorOutput();
            MirrorInputStream mirrorInputStream = mirrorConnection.getMirrorInput();
            byte[] byArray = MirrorOutputStream.mirrorTargetToBytes((String)CONFIGURATION_PATH, (String)string, (boolean)false);
            mirrorOutputStream.write(byArray);
            if (string2 != null) {
                mirrorOutputStream.writeUTF(string2);
            }
            mirrorOutputStream.flush();
            mirrorInputStream.readResponseHeader();
            int[] nArray = mirrorInputStream.readIntArray();
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            mirrorConnection.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getStringArray(String string, String string2) {
        MirrorConnection mirrorConnection = pool.getConnection(1);
        mirrorConnection.reserve();
        try {
            MirrorOutputStream mirrorOutputStream = mirrorConnection.getMirrorOutput();
            MirrorInputStream mirrorInputStream = mirrorConnection.getMirrorInput();
            byte[] byArray = MirrorOutputStream.mirrorTargetToBytes((String)CONFIGURATION_PATH, (String)string, (boolean)false);
            mirrorOutputStream.write(byArray);
            if (string2 != null) {
                mirrorOutputStream.writeUTF(string2);
            }
            mirrorOutputStream.flush();
            mirrorInputStream.readResponseHeader();
            String[] stringArray = mirrorInputStream.readStringArray();
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            mirrorConnection.release();
        }
        return null;
    }

    private static String[] getStringArray(String string) {
        return Permissions.getStringArray(string, null);
    }

    private static String[] getDomainNames() {
        return Permissions.getStringArray("getDomainNames");
    }

    private static String[] getFunctionGroups() {
        return Permissions.getStringArray("getFunctionGroups");
    }

    private static String[] getApiNames(String string) {
        return Permissions.getStringArray("getApiNames", string);
    }

    private static int[] getFunctionGroupModes(String string) {
        return Permissions.getIntArray("getFunctionGroupModes", string);
    }

    private static void readPermissionsTable(SecurityToken securityToken) throws InvalidJadException {
        String[] stringArray = Permissions.getDomainNames();
        String[] stringArray2 = Permissions.getFunctionGroups();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        Hashtable<String, int[]> hashtable2 = new Hashtable<String, int[]>();
        for (int k = 0; k < stringArray2.length; ++k) {
            hashtable.put(stringArray2[k], Permissions.getApiNames(stringArray2[k]));
            hashtable2.put(stringArray2[k], Permissions.getFunctionGroupModes(stringArray2[k]));
        }
        permissionsTable = new Hashtable();
        for (int k = 0; k < stringArray.length; ++k) {
            byte[] byArray = new byte[80];
            Permissions.clearPerms(byArray);
            Vector<String> vector = new Vector<String>();
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String[] stringArray3 = (String[])hashtable.get(stringArray2[i2]);
                vector.removeAllElements();
                for (int i3 = 0; i3 < stringArray3.length; ++i3) {
                    vector.addElement(stringArray3[i3]);
                }
                int[] nArray = null;
                nArray = (int[])hashtable2.get(stringArray2[i2]);
                if (nArray == null || nArray.length != stringArray.length) continue;
                byte by = (byte)(0xFF & nArray[k]);
                int n = by == 1 ? 1 : (by == 4 || by == 2 ? 1 : (by == 16 ? 16 : (by == 64 || by == 32 || by == 0 || by == -128 ? (int)by : 64)));
                Permissions.setPerms(byArray, vector, (byte)n, by);
            }
            permissionsTable.put(stringArray[k], byArray);
        }
    }

    private static boolean getPermissions(SecurityToken securityToken, String string, byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (permissionsTable == null) {
            try {
                Permissions.readPermissionsTable(securityToken);
            }
            catch (InvalidJadException invalidJadException) {
                return false;
            }
        }
        if (string.equals("trusted")) {
            string = TRUSTED_DOMAIN_NAME;
        }
        if ((byArray3 = (byte[])permissionsTable.get(string)) != null) {
            for (int k = 0; k < 40; ++k) {
                int n = k * 2;
                byArray[k] = byArray3[n];
                byArray2[k] = byArray3[n + 1];
            }
            return true;
        }
        return false;
    }
}

