/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.io;

import bluegammon.logic.BoardMediator;
import bluegammon.logic.PlayerListener;
import java.io.DataOutputStream;
import java.io.IOException;

public class PlayerListenerProxy
implements PlayerListener {
    public static final byte MOVE = 0;
    public static final byte UNDO = 1;
    public static final byte TURN = 2;
    public static final byte MSG = 3;
    public static final byte EXIT = 4;
    protected DataOutputStream m_out;

    public PlayerListenerProxy(DataOutputStream dataOutputStream) {
        this.m_out = dataOutputStream;
    }

    public void moveMade(int n, int n2) {
        try {
            this.m_out.writeByte(0);
            this.m_out.writeInt(n);
            this.m_out.writeInt(n2);
            this.m_out.flush();
        }
        catch (IOException iOException) {
            BoardMediator.lostRemoteConnection(iOException);
        }
    }

    public void undoPerformed(int n) {
        try {
            this.m_out.writeByte(1);
            this.m_out.writeInt(n);
            this.m_out.flush();
        }
        catch (IOException iOException) {
            BoardMediator.lostRemoteConnection(iOException);
        }
    }

    public void turnCommit(int n) {
        try {
            this.m_out.writeByte(2);
            this.m_out.writeInt(n);
            this.m_out.flush();
        }
        catch (IOException iOException) {
            BoardMediator.lostRemoteConnection(iOException);
        }
    }

    public void messageSent(int n, char[] cArray) {
        try {
            this.m_out.writeByte(3);
            this.m_out.writeInt(n);
            this.m_out.writeUTF(new String(cArray));
            this.m_out.flush();
        }
        catch (IOException iOException) {
            BoardMediator.lostRemoteConnection(iOException);
        }
    }

    public void gameExited(int n, int n2) {
        try {
            if (n2 == 2) {
                n2 = 3;
            } else if (n2 == 3) {
                n2 = 2;
            } else if (n2 == 1) {
                n2 = 0;
            } else if (n2 == 0) {
                n2 = 1;
            }
            this.m_out.writeByte(4);
            this.m_out.writeInt(n);
            this.m_out.writeInt(n2);
            this.m_out.flush();
        }
        catch (IOException iOException) {
            BoardMediator.lostRemoteConnection(iOException);
        }
    }
}

