/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.Audio;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.Context3D;
import bluegammon.gui.animation.Animation;
import bluegammon.logic.BoardMediator;
import bluegammon.logic.Rand;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public abstract class AbstractDicesAnim
extends Animation {
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int DX = 3;
    protected static final int DY = 4;
    protected static final int DZ = 5;
    protected static final int RX = 6;
    protected static final int RY = 7;
    protected static final int RZ = 8;
    protected static final int DRZ = 9;
    protected static final int WRX = 10;
    protected static final int WRY = 11;
    protected static final float Z_ON_BOARD = -35.0f;
    protected static final float G = -0.05f;
    protected static final float[] XROT = new float[]{0.0f, 90.0f, 0.0f, 0.0f, -90.0f, 180.0f};
    protected static final float[] YROT = new float[]{0.0f, 0.0f, 90.0f, -90.0f, 0.0f, 0.0f};
    protected float[] diceProps1 = new float[12];
    protected float[] diceProps2 = new float[12];
    protected boolean m_dice1White;
    protected boolean m_dice2White;
    protected int m_dice1;
    protected int m_dice2;
    protected int m_step;
    protected int m_diceStillStep;
    protected long m_diceStillTime;
    protected boolean m_playedSound = false;
    protected Transform m_trans = new Transform();
    protected static int[] m_shadow = null;
    protected static int m_factor;

    public static void init(int n) {
        m_factor = n * 7;
        m_shadow = Context3D.createShadowRGB(n * 14, 1);
    }

    public void onStart() {
        this.m_playedSound = false;
    }

    public AbstractDicesAnim(boolean bl, boolean bl2, int n, int n2) {
        this.m_dice1White = bl;
        this.m_dice2White = bl2;
        this.m_dice1 = n;
        this.m_dice2 = n2;
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        this.diceProps1[0] = boardCanvas.getWidth() / 2 - m_factor;
        this.diceProps1[3] = (Rand.randomFloat() - 0.7f) * ((float)boardCanvas.getWidth() / 200.0f);
        this.diceProps1[1] = boardCanvas.getHeight() - m_factor;
        this.diceProps1[4] = -((float)boardCanvas.getBoardHeight() / 150.0f) + (Rand.randomFloat() - 2.0f) * ((float)boardCanvas.getBoardHeight() / 400.0f);
        this.diceProps1[2] = -10.0f + 5.0f * Rand.randomFloat();
        this.diceProps1[5] = 0.0f;
        this.diceProps1[6] = 180.0f * Rand.randomFloat();
        this.diceProps1[7] = 180.0f * Rand.randomFloat();
        this.diceProps1[10] = XROT[n - 1];
        this.diceProps1[11] = YROT[n - 1];
        int n3 = (Rand.random() & 0xF) + 8;
        int n4 = -(Rand.random() & 0xF) - 8;
        if (-n4 > n3) {
            n3 = n4;
        }
        this.diceProps1[9] = n3;
        this.diceProps2[0] = boardCanvas.getWidth() / 2 + m_factor;
        this.diceProps2[3] = this.diceProps1[3] + (Rand.randomFloat() + 1.5f) * (float)boardCanvas.getWidth() / 300.0f;
        this.diceProps2[1] = this.diceProps1[1];
        this.diceProps2[4] = -((float)boardCanvas.getBoardHeight() / 150.0f) + (Rand.randomFloat() - 2.0f) * ((float)boardCanvas.getBoardHeight() / 400.0f);
        this.diceProps2[2] = -10.0f + 5.0f * Rand.randomFloat();
        this.diceProps2[5] = 0.0f;
        this.diceProps2[6] = 180.0f * Rand.randomFloat();
        this.diceProps2[7] = 180.0f * Rand.randomFloat();
        this.diceProps2[10] = XROT[n2 - 1];
        this.diceProps2[11] = YROT[n2 - 1];
        n3 = (Rand.random() & 0xF) + 8;
        n4 = -(Rand.random() & 0xF) - 8;
        if (-n4 > n3) {
            n3 = n4;
        }
        this.diceProps2[9] = n3;
        this.m_diceStillStep = -1;
    }

    public void paint(Graphics graphics) {
        Context3D context3D = Context3D.getInstance();
        int n = m_factor * 2;
        float f = this.diceProps1[0];
        float f2 = this.diceProps1[1];
        float f3 = this.diceProps1[2];
        float f4 = this.diceProps2[0];
        float f5 = this.diceProps2[1];
        float f6 = this.diceProps2[2];
        graphics.drawRGB(m_shadow, 0, n, (int)(f - (float)m_factor - context3D.toScreenCoordinateX(context3D.getShadowProjectionDeltaX(f3 - -35.0f), f3)), (int)(f2 - (float)m_factor), n, n, true);
        graphics.drawRGB(m_shadow, 0, n, (int)(f4 - (float)m_factor - context3D.toScreenCoordinateX(context3D.getShadowProjectionDeltaX(f6 - -35.0f), f6)), (int)(f5 - (float)m_factor), n, n, true);
        Graphics3D graphics3D = context3D.bindScene(graphics);
        this.m_trans.setIdentity();
        this.m_trans.postTranslate(context3D.to3DCoordinateX(f, -35.0f), context3D.to3DCoordinateY(f2, -35.0f), f3);
        this.m_trans.postRotate(this.diceProps1[6], 1.0f, 0.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps1[7], 0.0f, 1.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps1[8], 0.0f, 0.0f, 1.0f);
        this.m_trans.postRotate(this.diceProps1[10], 1.0f, 0.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps1[11], 0.0f, 1.0f, 0.0f);
        graphics3D.render(context3D.getDiceVertexBuffer(), context3D.getDiceIndexBuffer(), context3D.getDiceAppearance(this.m_dice1White), this.m_trans);
        this.m_trans.setIdentity();
        this.m_trans.postTranslate(context3D.to3DCoordinateX(f4, -35.0f), context3D.to3DCoordinateY(f5, -35.0f), f6);
        this.m_trans.postRotate(this.diceProps2[6], 1.0f, 0.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps2[7], 0.0f, 1.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps2[8], 0.0f, 0.0f, 1.0f);
        this.m_trans.postRotate(this.diceProps2[10], 1.0f, 0.0f, 0.0f);
        this.m_trans.postRotate(this.diceProps2[11], 0.0f, 1.0f, 0.0f);
        graphics3D.render(context3D.getDiceVertexBuffer(), context3D.getDiceIndexBuffer(), context3D.getDiceAppearance(this.m_dice2White), this.m_trans);
        graphics3D.releaseTarget();
    }

    public void next() {
        boolean bl = false;
        bl = this.updateDicePhysics(this.diceProps1);
        if ((bl |= this.updateDicePhysics(this.diceProps2)) && !this.m_playedSound) {
            this.m_playedSound = true;
            if (Math.abs(this.diceProps1[9]) + Math.abs(this.diceProps2[9]) > 38.0f) {
                Audio.playSound(1);
            } else {
                Audio.playSound(2);
            }
        }
        if (this.m_diceStillStep == -1 && this.isStill(this.diceProps1) && this.isStill(this.diceProps2)) {
            this.m_diceStillTime = System.currentTimeMillis();
            this.m_diceStillStep = this.m_step;
        }
        BoardCanvas.getInstance().requestRepaint();
        ++this.m_step;
    }

    public boolean isFinished() {
        return this.m_diceStillStep > 0 && (this.m_step > this.m_diceStillStep + 14 || System.currentTimeMillis() > this.m_diceStillTime + 1500L) || BoardMediator.isGameFinished();
    }

    public long getInterval() {
        return 20L;
    }

    protected boolean updateDicePhysics(float[] fArray) {
        boolean bl = false;
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        fArray[0] = fArray[0] + fArray[3];
        fArray[1] = fArray[1] + fArray[4];
        if (fArray[1] < (float)(boardCanvas.getBoardHeight() / 2 + m_factor) && fArray[4] < 0.0f) {
            fArray[4] = -fArray[4];
            fArray[1] = boardCanvas.getBoardHeight() / 2 + m_factor;
        }
        if (fArray[2] > -35.0f) {
            fArray[2] = fArray[2] + fArray[5];
            fArray[5] = fArray[5] + -0.05f;
            fArray[8] = fArray[8] + fArray[9];
            if (fArray[2] <= -35.0f) {
                fArray[5] = 0.0f;
                fArray[2] = -35.0f;
                bl = true;
            }
        } else {
            fArray[6] = fArray[6] % 360.0f;
            if (Math.abs(fArray[6]) < 13.0f) {
                fArray[6] = 0.0f;
            } else if (fArray[6] > 180.0f) {
                fArray[6] = fArray[6] + 12.0f;
            } else if (fArray[6] < 180.0f) {
                fArray[6] = fArray[6] - 12.0f;
            }
            fArray[7] = fArray[7] % 360.0f;
            if (Math.abs(fArray[7]) < 13.0f) {
                fArray[7] = 0.0f;
            } else if (fArray[7] > 180.0f) {
                fArray[7] = fArray[7] + 12.0f;
            } else if (fArray[7] < 180.0f) {
                fArray[7] = fArray[7] - 12.0f;
            }
            fArray[9] = fArray[9] * 0.95f;
            if (Math.abs(fArray[9]) < 2.0f) {
                fArray[9] = 0.0f;
            }
            fArray[8] = fArray[8] + fArray[9];
            fArray[3] = fArray[3] * 0.95f;
            if (Math.abs(fArray[3]) < 1.0f) {
                fArray[3] = 0.0f;
            }
            fArray[4] = fArray[4] * 0.95f;
            if (Math.abs(fArray[4]) < 1.0f) {
                fArray[4] = 0.0f;
            }
        }
        return bl;
    }

    protected boolean isStill(float[] fArray) {
        return fArray[2] == -35.0f & fArray[9] == 0.0f;
    }
}

